function svd_heatmap(D)

% Graphic depiction of Singular Value Decomposition using Heatmap

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% SVD for D codebook matrix
[U,S,V]=svd(D,0);

scrsz = get(0,'ScreenSize');
figure('Position',[scrsz(3)*1/20 scrsz(3)*1/20 scrsz(3)*7/10*(0.815/0.775) scrsz(3)*7/10])
set(gcf,'paperpositionmode','auto','color','w')
left_pos=0.03;

% Axes for codebook matrix D
h1_gca=axes('position',[left_pos 0.1 0.2 0.8]);
imagesc(D),caxis([-1 1])
title('Codebook matrix','fontsize',15,'color','k')
set(h1_gca,'box','off','xcolor','w','ycolor','w','ticklength',[0,0])
% Colorbar associated with the D axes 
pos1=get(h1_gca,'position');
h1_cb=colorbar('horiz','peer',h1_gca);
set(h1_gca,'position',pos1)
set(h1_cb,'position',[pos1(1) pos1(2)-0.02 pos1(3) 0.01],'xcolor','k','xtick',[-1 -0.5 0 0.5 1],'fontsize',7)

% Axes for U
h2_gca=axes('position',[left_pos+0.25 0.1 0.2 0.8]);
imagesc(U),caxis([-0.3 0.3])
title('U','fontsize',15,'color','k')
set(h2_gca,'xcolor','w','ycolor','w','ticklength',[0,0])
% Colorbar associated with the U axes 
pos2=get(h2_gca,'position');
h2_cb=colorbar('horiz','peer',h2_gca);
set(h2_gca,'position',pos2)
set(h2_cb,'position',[pos2(1) pos2(2)-0.02 pos2(3) 0.01],'xcolor','k','xtick',[-0.3 -0.15 0 0.15 0.3],'fontsize',7)

% Axes for S
h3_gca=axes('position',[left_pos+0.25*2 0.7 0.2 0.2]);
imagesc(S),caxis([-15 15])
title('S','fontsize',15,'color','k')
set(h3_gca,'box','off','xcolor','w','ycolor','w','ticklength',[0,0])
% Colorbar associated with the S axes 
pos3=get(h3_gca,'position');
h3_cb=colorbar('horiz','peer',h3_gca);
set(h3_gca,'position',pos3)
set(h3_cb,'position',[pos3(1) pos3(2)-0.02 pos3(3) 0.01],'xcolor','k','xlim',[0 15],'xtick',0:5:15,'fontsize',7)

% Axes for transposeed V
h4_gca=axes('position',[left_pos+0.25*3 0.7 0.2 0.2]);
imagesc(V'),caxis([-0.5 0.5])
title({'V^T'},'fontsize',15,'color','k')
set(h4_gca,'box','off','xcolor','w','ycolor','w','ticklength',[0,0])
% Colorbar associated with the transposeed V axes 
pos4=get(h4_gca,'position');
h4_cb=colorbar('horiz','peer',h4_gca);
set(h4_gca,'position',pos4)
set(h4_cb,'position',[pos4(1) pos4(2)-0.02 pos4(3) 0.01],'xcolor','k','xtick',[-0.5 -0.25 0 0.25 0.5],'fontsize',7)

% Axes for '='
h1_text=axes('position',[left_pos+0.2 0.8 0.05 0.05],'visible','off');
set(gcf,'CurrentAxes',h1_text)
text(0.3,0.5,'=','FontSize',20,'color','k')
% Axes for the first 'X'
h2_text=axes('position',[left_pos+0.2+0.25 0.8 0.05 0.05],'visible','off');
set(gcf,'CurrentAxes',h2_text)
text(0.3,0.5,'X','FontSize',15,'color','k')
% Axes for the second 'X'
h3_text=axes('position',[left_pos+0.2+0.25*2 0.8 0.05 0.05],'visible','off');
set(gcf,'CurrentAxes',h3_text)
text(0.3,0.5,'X','FontSize',15,'color','k')

return
